# standard imports
import json

# external imports
from clicada.user import FileUserStore
from chainlib.encode import TxHexNormalizer


categories = [
    'phone',
    'address',
        ]


def process_args(argparser):
    argparser.add_argument('--category', required=True, choices=categories, type=str, help='Identifier category')
    argparser.add_argument('identifier', type=str, help='Identifier to store a display tag for')
    argparser.add_argument('tag', type=str, help='Display tag to store for the identifier')


def extra_args():
    return {
        'category': None,
        'identifier': None,
        'tag': None,
            }


def apply_args(config, args):
    pass


def validate(config, args):
    if category not in categories:
        raise ValueError('Invalid category. Valid categories are: {}'.format(','.join(categories)))


def execute(ctrl):
    identifier = ctrl.get('_IDENTIFIER')
    if ctrl.get('_CATEGORY') == 'address':
        normalizer = TxHexNormalizer()
        identifier = normalizer.wallet_address(identifier)
    store_path = '.clicada'
    user_store = FileUserStore(None, ctrl.chain(), ctrl.get('_CATEGORY'), store_path, int(ctrl.get('FILESTORE_TTL')), encrypter=ctrl.encrypter)
    user_store.put(identifier, json.dumps(ctrl.get('_TAG')), force=True)
    user_store.stick(identifier)
