# standard imports
import os
import logging

# external imports
from chainlib.eth.tx import transaction
from leveldir.numeric import NumDir
from leveldir.hex import HexDir
from hexathon import strip_0x

logg = logging.getLogger(__name__)


class FileTxStore:

    subdivision = 100000

    def __init__(self, store_base_path, rpc=None, notifier=None):
        tx_base_path = os.path.join(store_base_path, 'tx')
        num_base_path = os.path.join(tx_base_path, 'blocks')
        hash_base_path = os.path.join(tx_base_path, 'hash')
        raw_base_path = os.path.join(tx_base_path, 'raw')
        self.block_index_dir = NumDir(num_base_path)
        self.hash_index_dir = HexDir(hash_base_path, 32)
        self.raw_index_dir = HexDir(raw_base_path, 32)
        self.rpc = rpc
        self.notifier = notifier


    def put(self, k, v, overwrite=False):
        if self.notifier != None:
            self.notifier.notify('caching tx data for {}'.format(k))
        hsh = bytes.fromhex(k)
        if not overwrite and self.hash_index_dir.have(k):
            logg.debug('tx store already has {}'.format(k))
            return

        self.hash_index_dir.add(hsh, v.encode('utf-8'))

        if self.rpc != None:
            self.notifier.notify('retrieve and cache raw tx data for {}'.format(k))
            o = transaction(k) 
            r = self.rpc.conn.do(o)
            raw = bytes.fromhex(strip_0x(r['raw']))
            self.raw_index_dir.add(hsh, raw)
