# standard imports
import logging

# local imports
from .interface import Keystore
from crypto_dev_signer.error import UnknownAccountError

logg = logging.getLogger()


class DictKeystore(Keystore):

    def __init__(self):
        self.keys = {}


    def get(self, address, password=None):
        if password != None:
            logg.debug('password ignored as dictkeystore doesnt do encryption')
        try:
            return self.keys[address]
        except KeyError:
            raise UnknownAccountError(address)


    def import_key(self, private_key_object, password=None):
        signer_address = private_key_object.public_key.to_checksum_address() # eth_keys.PrivateKey
        self.keys[signer_address] = private_key_object
        return signer_address
