# ECUTH

A library for authentication and authorization with EC signature, using random challenge/response.

EIP712 will be implemented as the default signature wrapper. This enables compatibility with metamask signatures. The feature will be possible to disable on a per-session basis, typically suitable for non-human authentication requests. It is also possible to disable it altogether in the configuration.


## Usage

1. Initialize `ecuth.SimpleRetriever` with:
	* A base url where ACL documents are located.
	* A block-box decrypter function (the test illustrates a gnupg use-case).
2. Call `challenge(ip, False)` to obtain a new secret for the new authenticating client `C`.
	* `C` is remembered with an expiry time.
3. Client generates an EIP712 serialization `E` of the secret acoording to the schema below.
4. Client signs `E` with an EIP155 signature, obtaining `S`.
5. Call `load(ip, C, S)` to verify client's response. This recovers the client's address `A`. It is verified if all of the below are true:
	* Ip/C pair matches an existing an already generated challenge that has not expired.
	* ACL document can be retrieved from base url using `A` as filename.
	* The decrypted function validates and/or decrypts the ACL document.
6. A "refresh token" and an "auth token" are generated, mimicing the token pair setup using in Oauth2.
	* "auth token" can be used in an `Authorization` header to authenticate the client.
	* While "refresh token" is not expired, `renew(A, refresh_token)` can be called to acquire a new "auth token"
7. Client can now query ACL:
	* Call `get(A, item)` to obtain the _raw_ access value for `item`.
	* Call `read(A, item)` to evaluate if _read_ access to `item` is granted.
	* Call `write(A, item)` to evaluate if _write_ access to `item` is granted.
8. Client can "log out" by calling `clear(A)`, which clears both tokens.
9. Client must perform challenge/response again after:
	* having logged out.
	* "refresh token" has expired.


## SimpleResolver ACL implementation

The package includes `SimpleRetriever`, a simple implementation of the `Retriever` interface. It retrieves ACL documents from base url using ethereum address hex values as file names.

The ACL items accepted by the SimpleRetriever constitute a simple key/value store. The document must:

* be a valid YML document.
* must have two top-level elements; `level` and `items`.
* `items` must be a collection of key/value entries on a single-level.
* the value of each `item` must be `0` (no access), `2` (write) or `4` (read). (any key with value 0 can optionally be omitted).

```
level: <level>
items:
  foo: 0
  foo.bar: 2
  xyzzy.baz: 4
  ...
```

### Interpretation

The `level` field defines an hierarchical criteria for changing data:

> If `level` of user `X` is _lower_  or _equal to_ `level` of user `Y`, then user `X`  **cannot** _change_ or _delete_ data for that user.

The values for the `items` keys are a simplificaiton of the `chmod` bitflag used in unix systems;

* If `0x04` is set, read access is granted.
* If `0x02` is set, write access is granted.

## EIP712 pseudo-schema 

```
const challenge_type = [
	{
	type: 'bytes',
	name: 'challenge',
	}
];

const domain_type = [
	{ 
		name: "name",
		type: "string"
	},
	{
		name: "version",
		ype: "string"
	},
	{
		name: "chainId",
		type: "uint256",
	},
//{ name: "verifyingContract", type: "address" },
//{ name: "salt", type: "bytes32" },
];

const data_to_serialize_and_sign = {
	types: {
		EIP712Domain: domain_type,
		Challenge: challenge_type,
	},
	primaryType: "Challenge",
	domain: <domain_data>,
	message: {
		challenge: <challenge_value>,
	},
}	
```

(`verifyingContract` and `salt` are commented out as the contract part not yet implemented)
