# standard imports
import uuid
import logging
import time
import eth_keys
import hashlib

logg = logging.getLogger()

DEFAULT_CHALLENGE_EXPIRE = 10


def source_hash(ip, data):
    h = hashlib.sha256()
    h.update(ip)
    h.update(data)
    k = h.digest()
    return k


class AuthChallenge:
    """Minimal convenience object representing an authentication challenge.

    :param address: Ethereum address of user
    :type address: str, 0x-hex
    """
    def __init__(self, ip, filters):
        self.ip = ip
        self.challenge = None
        self.challenge_expire = 0
        self.filter = filters


    def request(self):
        """Creates a new challenge.

        :return: Challenge value
        :rtype: bytes
        """
        uu = uuid.uuid4()
        self.challenge = uu.bytes
        self.challenge_expire = time.time() + DEFAULT_CHALLENGE_EXPIRE
        return (self.challenge, self.challenge_expire,)


    def apply_filters(self, s):
        for f in self.filter:
            logg.debug('applying filter {}'.format(f[0]))
            s = f[1](s)
        return s


    def clear(self):
        """Clears existing challenge data.
        """
        self.challenge = None
        self.challenge_expire = 0
