# standard imports
import logging

# third-party imports
import eip712_structs

logg = logging.getLogger()


class Challenge(eip712_structs.EIP712Struct):

    challenge = eip712_structs.Bytes()


class EIP712Filter:

    def __init__(self, name, version, chain_id):
        self.name = name
        self.version = version
        self.chain_id = chain_id


    def filter(self, s):
        c = Challenge()
        c['challenge'] = s
        d = eip712_structs.make_domain(
                name=self.name,
                version=self.version,
                chainId=self.chain_id,
                )
        z = c.signable_bytes(d)
        logg.debug('eip712 filter {} -> {}'.format(s.hex(), z.hex()))
        return z
