# standard imports
import logging

# third-party imports
import http_hoba_auth

logg = logging.getLogger()


class HobaFilter(http_hoba_auth.Hoba):
   
    def filter(self, s):
        if self.challenge != s:
            logg.error('challenge mismatch {} != {}'.format(self.challenge.hex(), s.hex()))
            raise ValueError('challenge mismatch')
        tbs = self.to_be_signed()
        logg.debug('hoba filter {} -> {}'.format(s, tbs))
        return tbs.encode('utf-8')
