# standard imports
import logging
import json
import os
import base64
import time
import hashlib

# third-party imports
import gnupg
import confini

# local imports
import ecuth
from ecuth.filter.eip712 import EIP712Filter
from ecuth.filter.hoba import HobaFilter

logging.basicConfig(level=logging.DEBUG)
logg = logging.getLogger()

script_dir = os.path.dirname(os.path.realpath(__file__))
root_dir = os.path.dirname(script_dir)
gpg_dir = os.path.join(root_dir, '.gnupg')
logg.debug('gpg dir {}'.format(gpg_dir))
gpg = gnupg.GPG(gnupghome=gpg_dir)



def sha256filter(s):
    h = hashlib.sha256()
    h.update(s)
    z = h.digest()
    logg.debug('sha256 filter {} -> {}'.format(s, z))
    return z


# GNUPG data pluggable test decrypter
def decrypter(data):
    d = gpg.decrypt(data, passphrase='tralala')
    if d.trust_level < d.TRUST_FULLY:
        raise ValueError('untrusted data')
    logg.debug('trust {}'.format(d.trust_level))
    return str(d)

config = confini.Config(os.path.join(root_dir, 'config'))
config.process()
retriever = ecuth.SimpleRetriever(config, decrypter)

hoba_filter = HobaFilter(config.get('HTTP_AUTH_ORIGIN'), config.get('HTTP_AUTH_REALM'))
eip712_filter = EIP712Filter(config.get('EIP712_NAME'), config.get('EIP712_VERSION'), config.get('ECUTH_CHAIN_ID'))
retriever.add_challenge_filter(hoba_filter.filter, 'hoba')
retriever.add_challenge_filter(sha256filter)
retriever.add_challenge_filter(eip712_filter.filter, 'eip712')


def application(env, start_response):

    for k in env.keys():
        logg.debug('env {} {}'.format(k, env[k]))

    headers = [('Content-Type', 'text/html;charset=UTF-8')]

    auth_state = False

    token = None
    auth = env.get('HTTP_AUTHORIZATION')
    if auth != None:
        (b, token) = auth.split(' ')
        if b.lower() == 'hoba':
#            (challenge_b64, signature_b64) = token.split(':')
#            challenge = base64.decodebytes(challenge_b64.encode('utf-8'))
#            signature_bytes = base64.decodebytes(signature_b64.encode('utf-8'))
#            logg.debug('challenge {} signature {}'.format(challenge.hex(), signature_bytes.hex()))
           
            # TODO: AUTH_ORIGIN should be collected from available server certs instead
            #hoba = http_hoba_auth.Hoba(config.get('HTTP_AUTH_ORIGIN'), config.get('HTTP_AUTH_REALM'))
            hoba_filter.parse(token) 
            #tosign = hoba_filter.to_be_signed()

            tokens = retriever.load(env.get('REMOTE_ADDR'), hoba_filter.challenge, hoba_filter.signature)
            headers = [
                    ('Content-Type', 'application/json;charset=UTF-8',),
                    ('Cache-Control', 'none',),
                    ]
            expires_in = int(tokens[2] - time.time())
            data = {
                'access_token': tokens[0].hex(),
                'token_type': 'Bearer',
                'expires_in': expires_in,
                'refresh_token': tokens[1].hex(),
                    }
            data_json = json.dumps(data)
            data_bytes = data_json.encode('utf-8')
            #headers.append(('Content-Length', str(data_bytes),))
            start_response('200 OK', headers)
            return [data_bytes]
        
#        elif b.lower() != 'bearer':
#            start_response('403 Forbidden', headers)
#            return [b'']
#            try:
#                token_bytes = base64.decodebytes(token.encode('utf-8'))
#            except:
#                start_response('400 Invalid request', headers)
#                return [b'']
#            try:
#                authed = retriever.check(token_bytes)
#            except:
#                start_response('403 Forbidden', headers)
#                return [b'']


    response = ''
    if auth_state:
        post_data = None
        f = env.get('wsgi.input')
        c = f.read(1)
        if len(c) > 0:
            f.seek(0)
            post_data = json.load(f)
        f.close()
        headers.append(('Content-Length', 0,))
        start_response('200 OK', headers)
        return [b'']

    else:
        if env.get('REQUEST_URI') == '/request':
            (nonce, expires) = retriever.challenge(env.get('REMOTE_ADDR'))
            nonce_b64 = base64.b64encode(nonce)
            logg.debug('sending nonce {} {}'.format(nonce.hex(), nonce_b64.decode('utf-8')))

            expires_duration = expires - time.time()
            wwwauth_header_value  = 'challenge="{}",max-age="{}",realm="{}"'.format(
                nonce_b64.decode('utf-8'),
                int(expires_duration),
                config.get('HTTP_AUTH_REALM')
            )
            wwwauth_header = ('WWW-Authenticate', 'HOBA {}'.format(wwwauth_header_value))
            headers.append(wwwauth_header)

        response = login_page()

        response_bytes = response.encode('utf-8')
        content_length = len(response_bytes)
        headers.append(('Content-Length', str(content_length),))

        start_response('401 Unauthorized', headers)
        return [response_bytes]


def login_page():
    f = open(os.path.join(script_dir, 'html', 'login.html'))
    d = f.read(1024*1024)
    f.close()
    return d
