import re
import uuid
import json
import logging

from gas_proxy.proxy import JSONRPCOracle
from gas_proxy.cache.mem import MemCache

logg = logging.getLogger()


def jsonrpc_response(r):
    uu = uuid.uuid4()
    return {
        "jsonrpc": "2.0",
        "id": str(uu),
        "result": r,
        }

def jsonrpc_request():
    uu = uuid.uuid4()
    return {
        "jsonrpc": "2.0",
        "id": str(uu),
        "method": "eth_gasPrice",
        "params": [],
            }

re_gas = 'eth_gasPrice'


class GasMiddleware:

    socket_constructor = None

    def __init__(self, make_request, w3):
        self.w3 = w3
        self.make_request = make_request
        self.errored = True
        self.socket = None


    def __call__(self, method, params):

        if re_gas == method:
            logg.debug('middleware gas handler')
            request_id = uuid.uuid4()
            o_req = jsonrpc_request()
            o_res = None

            try:
                if self.errored:
                    logg.debug('attempting socket reconnect')
                    self.socket = GasMiddleware.socket_constructor()
                    self.errored = False
                self.socket.send(json.dumps(o_req))
                r = self.socket.recv()
                o_res = json.loads(r)
                GasMiddleware.last_gas = o_res['result']
            except Exception as e:
                self.errored = True
                logg.exception('gas backend query failed {}')
                o_res = jsonrpc_response(self.last_gas)

            return o_res


        r = self.make_request(method, suspect_params)
        return r
