#include <string.h>

#include "endian.h"
#include "rlp.h"

static int process_state_token(rlp_encoder_t *encoder) {
	int len = 0;
	int lenlen = 0;
	int r;
	unsigned char token;

	token = *encoder->ptr;

	if (token >= 0xf7) {
		lenlen = token - 0xf7;
		encoder->ptr++;
		len = 0;
		memcpy(&len, encoder->ptr, lenlen);
		if (lenlen > 1 && is_le()) {
			to_endian(CONVERT_LITTLEENDIAN, lenlen, &len);
		}
		encoder->list_ptr[encoder->depth] = (char*)&len;
		encoder->ptr += lenlen;

		r = encoder->depth;
		encoder->depth++;
		encoder->state = RLP_LIST;

	} else if (token >= 0xc0) {
		len = token - 0xc0;
		if (is_le()) {
			to_endian(CONVERT_LITTLEENDIAN, sizeof(len), &len);
		}
		encoder->list_ptr[encoder->depth] = (char*)&len;
		encoder->ptr++;

		r = encoder->depth;
		encoder->depth++;
		encoder->state = RLP_LIST;
	} else if (token >= 0xb7) {
		lenlen = token - 0xb7;
		encoder->ptr++;
		len = 0;
		memcpy(&len, encoder->ptr, lenlen);
		if (lenlen > 1 && is_le()) {
			to_endian(CONVERT_LITTLEENDIAN, lenlen, &len);
		}
		encoder->ptr += lenlen;
		
		encoder->list_ptr[encoder->depth] = encoder->ptr;
		r = encoder->depth;
		encoder->ptr += len;
		encoder->depth--;
		encoder->state = RLP_STRING;
	} else if (token >= 0x80) {
		len = token - 0x80;
		encoder->ptr++;

		encoder->list_ptr[encoder->depth] = encoder->ptr;
		r = encoder->depth;
		encoder->ptr += len;
		encoder->depth--;
		encoder->state = RLP_STRING;
	} else {
		encoder->list_ptr[encoder->depth] = encoder->ptr;
		r = encoder->depth;
		encoder->ptr++;
		encoder->depth--;
		encoder->state = RLP_STRING;
	}

	return r;
}

static int assert_complete(rlp_encoder_t *encoder) {
	int r = 0;

	if (encoder->ptr - encoder->buf < encoder->size) {
		encoder->state = RLP_INCOMPLETE;
		r = -1;
	} else if (encoder->ptr - encoder->buf > encoder->size) {
		encoder->state = RLP_OVERFLOW;
		r = -1;
	} else {
		encoder->state = RLP_END;
	}
	return r;
}

int rlp_next(rlp_encoder_t *encoder, int *zlen, char **zdest) {
	int r;

	if (encoder->depth == -1) {
		return assert_complete(encoder);
	}
	
	r = process_state_token(encoder);
	
	switch (encoder->state) {
		case RLP_LIST:
			*zlen = *((int*)encoder->list_ptr[r]);
			break;

		case RLP_STRING:
			*zlen = encoder->ptr - encoder->list_ptr[r];
			break;
	}	
	*zdest = encoder->list_ptr[r];

	return 0;
}
