from setuptools import setup

setup(
        name='sempo-cli',
        version='0.1.1',
        description='Command line interfaces for batching sempo API calls',
        author='Louis Holbrook',
        author_email='dev@holbrook.no',
        packages=[
            'sempo_cli.cmd',
            ],
        install_requires=[
            'vobject==0.9.6.1',
            'xdg==4.0.1',
            'python-gnupg==0.4.5',
            'confini @ git+https://gitlab.com/nolash/python-confini.git',
            'sempo-client @ git+https://gitlab.com/grassrootseconomics/sempo-client.git',
            ],
        scripts=[
            'scripts/sempo-cli',
            'scripts/sempo-ussd',
            ],
        data_files = [('', ['LICENSE.txt'])],
        url='https://gitlab.com/grassrootseconomics/sempo-cli',
        classifiers=[
            'Programming Language :: Python :: 3',
            'Operating System :: OS Independent',
            'Development Status :: 3 - Alpha',
            'Environment :: Console',
            'Intended Audience :: End Users/Desktop',
            'License :: OSI Approved :: GNU General Public License v3 or later (GPLv3+)',
            'Topic :: Utilities',
            ],
        )
