import logging

logg = logging.getLogger(__file__)

class BaseClient:

    def __init__(self, host='localhost', port=9000, use_ssl=True):
        logg.debug('setting up api client {} {} ssl: {}'.format(host, port, use_ssl))
        self.host = host
        self.port = port
        self.proto = 'http'
        if use_ssl:
            self.proto += 's'
        self.api_url_core = self.proto + '://' + self.host + ':' + str(self.port) + '/api/v{}'
        self.username = None
        self.password = None



    def api_url(self, version=1):
        return self.api_url_core.format(version)


    @classmethod
    def authorize(self, username, password):
        pass


    @classmethod
    def get(self, endpoint, version):
        pass


    @classmethod
    def post(self, endpoint, data, version):
        pass


    @classmethod
    def put(self, endpoint, data, version):
        pass
